 ; Ŀ
 ;   Bimp - Make Windows Metafiles of a directory of drawings.             
 ;   Copyright 2000, 2003 by Rocket Software Ltd.                          
 ;   The scientific term for the larval form of an airship.                
 ; 

 ; Ŀ
 ;   Wif - make a Windows Metafile of selected entities.                   
 ;   Returns nothing, at least not by choice.                              
 ; 
 (DEFUN C:WIF (/ fnamp fnam ss)
  (setvar "wmfbkgnd" 0)
  (setvar "wmfforegnd" 0)
 ; Ŀ
 ;   Make a directory path and default name string, get a name.            
 ; 
  (setq fnamp (strcat (getvar "dwgprefix") (getvar "dwgname")))
  (if (= (substr (strcase fnamp t) (- (setq len (strlen fnamp)) 3)) ".dwg")
      (setq fnamp (substr fnamp 1 (- len 4))))
  (setq fnam (getfiled "Windows Metafile Name" fnamp "wmf" 1))
 ; Ŀ
 ;   Ask for entities.                                                     
 ; 
  (prompt "Select entities or <Return> for All: ")
  (if (not (setq ss (ssget)))
      (setq ss (ssget "X")))
  (command "export" fnam ss "")
 (princ))
 ; Ŀ
 ;   Wif end.                                                              
 ; 

 ; Ŀ
 ;   Woomf - make a Windows Metafile of the drawing.                       
 ;   Arguments: Fnam, The file name.                                       
 ;   Returns nothing, at least not by choice.                              
 ; 
 (defun woomf (fnam /)
  (command "export" (strcat fnam ".wmf") "all" ""))
 ; Ŀ
 ;   Woomf end.                                                            
 ; 

 ; Ŀ
 ;   Dirge - get a list of filenames.                                      
 ;   Currently takes no arguments.                                         
 ;   Returns a list: the path, and a list of filenames with paths.         
 ; 
 (DEFUN DIRGE (/ pat prefa pref fils num fnam nulis)
  (if (= "" (setq pat (getstring "Pattern <*.dwg>: ")))
      (setq pat "*.dwg"))
  (setq prefa (getvar "dwgprefix"))
  (if (= "" (setq pref (getstring (strcat "Directory <" prefa ">: "))))
      (setq pref prefa))
  (setq fils (vl-directory-files pref pat 1))
 ; Ŀ
 ;   Put the filename list in alphabetical order.                          
 ; 
  (setq fils (acad_strlsort fils))
  (setq num 0)
  (while (and fils (setq fnam (nth num fils)))
         (setq num (1+ num))
         (setq fnam (strcat pref fnam))
         (setq nulis (cons fnam nulis)))
 ; Ŀ
 ;   Return a list: (drawing prefix (drawing names)).                      
 ; 
 (list prefa (reverse nulis)))
 ; Ŀ
 ;   Dirge end.                                                            
 ; 

 ; Ŀ
 ;   Bimp.                                                                 
 ; 
 (DEFUN C:BIMP (/ dwglst dwg)
  (setq dwglst (dirge))
  (setvar "wmfbkgnd" 0)
  (setvar "wmfforegnd" 0)
 ; Ŀ
 ;   Remove the outer list, return the last sublist.                       
 ; 
  (setq dwglst (cadr dwglst))
  (while (setq dwg (car dwglst))
         (setq dwglst (cdr dwglst))
         (command "erase" "all" "")
         (if (/= dwg (strcat (getvar "dwgprefix") (getvar "dwgname")))
             (progn
                  (if (= (substr (strcase dwg t)
                                 (- (setq len (strlen dwg)) 3)) ".dwg")
                      (setq dwg (substr dwg 1 (- len 4))))
                  (command "-insert" dwg "0,0" "1" "" "0")
                  (while (= 1 (getvar "cmdactive"))
                         (command ""))
                  (command ".zoom" "e")
                  (command ".zoom" "0.95x")
                  (command ".regenall")
                  (woomf dwg))))
  (command "erase" (entlast) "")
 (princ))